<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\Species;
class Species extends Model
{
    protected $table= "species";
    use HasFactory;
    
     // Define the parent relationship
    public function parent_id()
    {
        return $this->belongsTo(Species::class, 'parent_id');
    }

    // Define the children relationship (optional but useful)
    public function children()
    {
        return $this->hasMany(Species::class, 'parent_id');
    }
    
    
}
