<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Models\FinalArticle;

class Feedback extends Model
{
    use HasFactory;

    protected $table = "feedback";

    protected $fillable = ['user', 'article_id', 'feedback', 'status'];

    /**
     * Define the relationship with FinalArticle
     */
    public function article()
    {
        return $this->belongsTo(FinalArticle::class, 'article_id');
    }
}
