<?php

namespace App\Http\Controllers;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\Models\FinalArticle;
use App\Models\ResearchTopics;
use App\Models\StudyType;
use App\Models\Systems;
use App\Models\Species;
use App\Models\Organs;
use App\Models\Countries;
use App\Models\Authors;
use App\Models\Roles;
use App\Models\BioCategories;
use App\Models\AdministrationMethods;
use App\Models\Feedback;


class AdminController extends Controller
{
    public function getAssignedArticles(Request $req)
    {
        $perPage = $req->input('per_page', 10);
        $page = $req->input('page', 1);
        
           
        
        
        $query = FinalArticle::query();
        $query->with('reviewer');
        $query->where('reviewer_id', auth()->user()->id);
        $query->orderBy('id', 'DESC');
        $articles = $query->paginate($perPage, ['*'], 'page', $page);
        
        $decodedArticles = $articles->map(function ($article) {
    
            
            return [
                'id' => $article->id,
                'mhid' => $article->mhid,
                'doi' => $article->doi,
                'pmid' => $article->pmid,
                'status' => $article->status,
                'publicData' => json_decode($article->publicData, true),
                'articleGeneralData' => json_decode($article->articleGeneralData, true),
                'researcherData' => json_decode($article->researcherData, true),
                'biomaker' => json_decode($article->biomaker, true),
                'created_at' => $article->created_at,
                'updated_at' => $article->updated_at,
                'reviewer'=>$article->reviewer
            ];
        });
        
        
        return response()->json(['status'=>true, 'data'=>['articles'=>$decodedArticles],'current_page' => $articles->currentPage(),
            'per_page' => $articles->perPage(),
            'total' => $articles->total(),
            'last_page' => $articles->lastPage(),]);
    }
    public function getListArticlesForAssignment(Request $req)
    {
        $perPage = $req->input('per_page', 10);
        $page = $req->input('page', 1);
        
           
        
        
        $query = FinalArticle::query();
        $query->with('reviewer');
        $query->orderBy('id', 'DESC');
        $articles = $query->paginate($perPage, ['*'], 'page', $page);
        
        $decodedArticles = $articles->map(function ($article) {
    
            
            return [
                'id' => $article->id,
                'mhid' => $article->mhid,
                'doi' => $article->doi,
                'pmid' => $article->pmid,
                'status' => $article->status,
                'publicData' => json_decode($article->publicData, true),
                'articleGeneralData' => json_decode($article->articleGeneralData, true),
                'researcherData' => json_decode($article->researcherData, true),
                'biomaker' => json_decode($article->biomaker, true),
                'created_at' => $article->created_at,
                'updated_at' => $article->updated_at,
                'reviewer'=>$article->reviewer
            ];
        });
        
        
        $articlesCount = FinalArticle::count();
        $verfiedArticles = FinalArticle::where('status', 'Verified')->count();
        $researchersCount = User::where('role','Researcher')->where('status','Active')->count();
        $assignedArticles = FinalArticle::where('reviewer_id','!=',null)->count();
        
        
        return response()->json(['status'=>true, 'data'=>['articles'=>$decodedArticles,'verifiedArticles'=>$verfiedArticles,'researchersCount'=>$researchersCount, 'assignedArticles'=>$assignedArticles,'articlesCount'=>$articlesCount],'current_page' => $articles->currentPage(),
            'per_page' => $articles->perPage(),
            'total' => $articles->total(),
            'last_page' => $articles->lastPage(),]);
    }
    
    public function assignReviewer(Request $req)
    {
        
        // dd($req);
        
        if(!isset($req->article_id) || !isset($req->rid))
        {
            return response()->json(['status'=>false, 'message'=>"Article or User ID missing"]);
        }
        
        $article = FinalArticle::where('id', $req->article_id)->first();
        // dd($article);
        if(!$article)
        {
            return response()->json(['status'=>false, 'message'=>"Article not found!"]);
        }
        
        $article->reviewer_id= $req->rid;
        
        $article->save();
        
        
        $narticle = FinalArticle::with('reviewer')->where('id', $req->article_id);
        return response()->json(['status'=>true, 'message'=>'Reviewer Assigned to Article','article'=>$narticle]);
    }
    public function updateFeedbackStatus(Request $req, $id)
    {
        if($id)
        {
            $feedback = Feedback::find($id);
            if(!$feedback)
            {
                return response()->json(['status'=>false,'message'=>'No Feedback Found']);
            }
            
            if(isset($req->status))
            {
                $feedback->status = $req->status;
                $feedback->save();
                return response()->json(['status'=>true,'message'=>'Status Updated', 'feedback'=>$feedback]);
            }
            return response()->json(['status'=>true,'message'=>'Feedback Found', 'feedback'=>$feedback]);
        }
        else
        {
            return response()->json(['status'=>false,'message'=>'No Feedback Found'], 404);
        }
    }
    
    
    public function ltFilters(){
         $systems = Systems::pluck('name');
    $species = Species::where('parent_id', null)->pluck('name');
    $topics = ResearchTopics::pluck('name');
        
        return response()->json([
            'status' => true,
            'data' => [
                'systems' => $systems,
                'species' => $species,
                'topics' => $topics
            ]
        ]);
    }
   public function getFeedbacks(Request $request)
{
    $limit = $request->input('limit', 10);
    // Fix: Add proper column name and direction
    $paginator = Feedback::with(['article'])
        ->orderBy('created_at', 'desc')  // Fixed here
        ->paginate($limit);


    // Get status counts
    $statusCounts = Feedback::selectRaw('
        COUNT(CASE WHEN status = "Resolved" THEN 1 END) as resolved,
        COUNT(CASE WHEN status = "In Progress" THEN 1 END) as in_progress,
        COUNT(CASE WHEN status = "Pending" THEN 1 END) as pending,
        COUNT(*) as total
    ')->first();
    
    $transformed = $paginator->getCollection()->map(function ($item) {
        
        $article = FinalArticle::find($item->article_id);
        // dd($article->id);
        return [
        'id' => $item->id,
        'user' => json_decode($item->user),
        'article' => $article ? [
            'id' => $article->id,
            'mhid' => $article->mhid,
            'doi' => $article->doi,
            'title' => json_decode($article->publicData, true)['title']['name'] ?? null,
        ] : null,
        'feedback' => json_decode($item->feedback),
        'status' => $item->status,
        'created_at' => $item->created_at->toIso8601String(),
    ];
    });

    return response()->json([
        'success' => true,
        'message' => 'Feedback retrieved successfully',
        'data' => $transformed,
        'pagination' => [
            'current_page' => $paginator->currentPage(),
            'total' => $paginator->total(),
            'per_page' => $paginator->perPage(),
            'last_page' => $paginator->lastPage(),
        ],
        'status_counts' => [
            'Resolved' => (int)$statusCounts->resolved,
            'In Progress' => (int)$statusCounts->in_progress,
            'Pending' => (int)$statusCounts->pending,
            'total' => (int)$statusCounts->total
        ]
    ]);
}
    public function FeedbackStore(Request $request)
    {
    // Ensure user and feedback are stored as JSON
    $feedback = Feedback::create([
        'user' => json_encode($request->user), // Convert to JSON if needed
        'article_id' => (int) $request->article_id, // Ensure it's an integer
        'feedback' => json_encode($request->feedback), // Convert to JSON
        'status' => $request->status ?? 'Pending'
    ]);

    return response()->json([
        'success' => true,
        'message' => 'Feedback saved successfully',
        'data' => $feedback
    ], 201);
}
    public function deleteBioCategory($id)
    {
        if(!isset($id))
        {
            return response()->json(['status'=>false,'message'=>'ID Not Found']);
        }
        $bio = BioCategories::where('id',$id)->first();
        if($bio)
        {
            $bio->delete();
            return response()->json(['status'=>true,'message'=>"Deleted"]);
        }
        else
        {
            return response()->json(['status'=>true,'message'=>'Not Found']);
        }
    }
    public function addBioCategory(Request $req)
    {
        $check = BioCategories::where('name', $req->name)->first();
        if($check)
        {
            return response()->json(['status'=>false,'message'=>'Data already exist']);
        }
        $bio = new BioCategories();
        $bio->name= $req->name;
        $bio->save();
        return response()->json(['status'=>true,'data'=>$bio]);
    }
    
    public function bioCategoriesById($id)
    {
        // dd($id);
        if(!isset($id))
        {
            return response()->json(['status'=>false,'message'=>'ID Not Found']);
        }
        
        $bio = BioCategories::where('id',$id)->first();
        if($bio)
        {
            return response()->json(['status'=>true,'data'=>$bio]);
        }
        else
        {
            return response()->json(['status'=>true,'message'=>'Not Found']);
        }
        
    }
    
    public function updateBioCategory(Request $req, $id )
    {
        $bio = BioCategories::where('id',$id)->first();
        if($bio)
        {
            if(isset($req->name))
            {
                $bio->name = $req->name;
                $bio->save();
                 return response()->json(['status'=>true,'data'=>$bio]);
            }
            else
            {
                return response()->json(['status'=>true,'message'=>'Nothing to update']);
            }
        }
        else
        {
            return response()->json(['status'=>true,'message'=>'Not Found']);
        }
    }
    
    public function uploadArticle(Request $req)
{
    // Validate the request (Only allow PDFs)
    $validator = Validator::make($req->all(), [
        'article' => 'required|mimes:pdf',
    ]);

    // If validation fails, return a JSON response
    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'message' => 'Validation failed',
            'errors' => $validator->errors()
        ], 422);
    }

    // Get authenticated user ID
    $userId = auth()->user()->id;

    // Check if the file exists in the request
    if ($req->hasFile('article')) {
        $file = $req->file('article');
        
        // Generate a unique filename using user ID and timestamp
        $filename = $userId . '_' . time() . '_' . $file->getClientOriginalName();
        $path = 'assets/pdf'; // Path within the public directory

        // Move file to public/assets/pdf directory
        $file->move(public_path($path), $filename);

        // Generate the full URL
        $fileUrl = url($path . '/' . $filename);

        return response()->json([
            'success' => true,
            'message' => 'File uploaded successfully',
            'article_url' => $fileUrl
        ], 200);
    }

    return response()->json([
        'success' => false,
        'message' => 'File upload failed'
    ], 400);
}


 public function uploadImages(Request $req)
{
    // Validate the request (Only allow PDFs)
    $validator = Validator::make($req->all(), [
        'image' => 'required',
    ]);

    // If validation fails, return a JSON response
    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'message' => 'Validation failed',
            'errors' => $validator->errors()
        ], 422);
    }



    // Check if the file exists in the request
    if ($req->hasFile('image')) {
        $file = $req->file('image');
        
        // Generate a unique filename using user ID and timestamp
        $filename = time() . '_' . $file->getClientOriginalName();
        $path = 'assets/contact'; // Path within the public directory

        // Move file to public/assets/pdf directory
        $file->move(public_path($path), $filename);

        // Generate the full URL
        $fileUrl = url($path . '/' . $filename);

        return response()->json([
            'success' => true,
            'message' => 'File uploaded successfully',
            'image_url' => $fileUrl
        ], 200);
    }

    return response()->json([
        'success' => false,
        'message' => 'File upload failed'
    ], 400);
}



    
   public function checkArticle(Request $request)
    {
    // Validate the request
    $request->validate([
        'pmid' => 'nullable|string',
        'title' => 'nullable|string',
        'doi' => 'nullable|string'
    ]);

    // Extract input values
    $pmid = $request->input('pmid');
    $title = $request->input('title');
    $doi = $request->input('doi');

    // Start query builder
    $query = FinalArticle::query();

    // Add conditions dynamically based on provided input
    if (!empty($pmid)) {
        $query->orWhere('pmid', $pmid);
    }
    if (!empty($title)) {
        $query->orWhereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) = ?", [$title]);
    }
    if (!empty($doi)) {
        $query->orWhereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.doi.name')) = ?", [$doi]);
        $query->orWhere('doi',$doi);
    }

    // Get the first matching article
    $article = $query->first();

    // Return response
    if ($article) {
        $article->publicData = isset($article->publicData) ? json_decode($article->publicData,true): null;
        $article->articleGeneralData = isset($article->articleGeneralData) ? json_decode($article->articleGeneralData,true): null;
        $article->researcherData = isset($article->researcherData) ? json_decode($article->researcherData,true): null;
        $article->biomaker = isset($article->biomaker) ? json_decode($article->biomaker,true): null;
        return response()->json(['status' => 'found', 'article' => $article]);
    } else {
        return response()->json(['status' => 'not found','article'=>null], 200);
    }
}
    
    public function editCountry(Request $req, Countries $country)
    {
        if(!isset($req->name))
        {
            return response()->json(['status'=>false, 'message'=>'Name is missing']);
        }
        
        $country->name = $req->name;
        $country->status = isset($req->status) ? $req->status : $country->status;
        $country->save();
        return response()->json(['status'=>true, 'message'=>'Updated', 'country'=>$country]);
    }
    
    public function deleteCountry(Request $req, Countries $country)
    {
        if(!isset($country->id))
        {
            return response()->json(['status'=>false, 'message'=>'Country not found']);
        }
        
        $country->delete();
    
        return response()->json(['status'=>true, 'message'=>'Deleted', 'country'=>$country]);
    }
    public function getCountries()
    {
        $countries = Countries::get();
        return response()->json(['status'=>true, 'countries'=>$countries]);
    }
    
    public function addCountries(Request $req)
    {
        $check = Countries::where('name',$req->name)->first();
        if($check)
        {
            return response()->json(['status'=>false,'message'=>'Already Exist in database']);
        }
        $coun = new Countries();
        $coun->name = $req->name;
        $coun->status = isset($req->status) ? $req->status : "Pending";
        $coun->save();
        
        return response()->json(['status'=>true, 'country'=>$coun]);
    }
    
    public function getAuthChildren()
    {
        $auArray = [];
        $authors = Authors::get();
        $auName = [];
        $authors = $authors->toArray();
        foreach($authors as $val)
        {
            $auArray[$val['id']] = ['name'=>$val['name'], 'childrens'=>[]];
            $auName[]= $val['name'];
        }
        
        $articles = FinalArticle::get();
        foreach($articles as $art)
        {
            $decode = json_decode($art->publicData,true);
            //  dd($decode);
            if(isset($decode['authors']) && is_array($decode['authors']))
            {
               
                foreach($decode['authors'] as $a)
                {
                    if(isset($a['parent_id']))
                    {
                        $auArray[intval($a['parent_id'])]['childrens'][] = $a['name'];    
                    }
                     
                }
            }
        }
      
      return response()->json(['status'=>true,'authors'=>$auArray,'au_names'=>$auName]);
    }

     
   public function editAuthor(Request $req, Authors $author)
   {
       $author->name = $req->name;
       $author->save();
       return response()->json(['status'=>true, 'message'=>'Author Updated', 'author'=>$author]);
   }
   public function addAuthor(Request $req)
   {
       if(!isset($req['name']))
       {
           return response()->json(['status'=>true, 'message'=>'Name is required']);
       }
       
       $check = Authors::where('name',$req['name'])->first();
       if($check)
       {
           return response()->json(['status'=>false, 'message'=>'Author with this name already exist', 'author'=>$check]);
       }
       $author = new Authors();
       $author->name = $req['name'];
       $author->save();
       return response()->json(['status'=>true, 'author'=>$author]);
   }
   
   
   public function addAuthorChild(Request $req)
   {
       if(!isset($req['id']) || !isset($req['child']))
       {
           return response()->json(['status'=>false, 'message'=>'Missing Fields']);
       }
       
   }
    
   public function getAuthors()
   {
       $authors = Authors::where('id','!=',1)->get();
       return response()->json(['status'=>true, 'authors'=>$authors]);
   }
   public function makeParent(Request $req)
   {
       
   }
   public function verifyAuthor(Request $req)
   {
       
       $reqAuthors = isset($req['authors']) ? $req['authors']:[];
       if(count($reqAuthors) > 0 && isset($req['mhid']))
       {
          $article = FinalArticle::where('mhid', $req['mhid'])->first();
          if(!$article)
          {
              return response()->json(['status'=>false, 'message'=>'Article Not Found']);
          }
          $publicData = json_decode($article->publicData, true);
          $publicData['authors'] = $reqAuthors;
          $article->publicData = json_encode($publicData,true);
          $article->save();
          return response()->json(['status'=>true, 'message'=>'Article Author Updated']);
       }
     return response()->json(['status'=>false,'message'=>'Authors not found']);
   }
   
   public function getArticleAuthors(){
       $articles = FinalArticle::orderBy('id', 'DESC')->get()->take(10)->map(function ($item) {
                $author_verified = true;
                $pdata = json_decode($item->publicData, true);
                if(isset($pdata['authors']) && is_array($pdata['authors']))
                {
                    foreach($pdata['authors'] as $val)
                    {
                        if(isset($val['parent_id']) && intval($val['parent_id']) == 1)
                        {
                            $author_verified = false;
                        }
                        
                    }
                }
                else
                {
                    $author_verified = false;
                }
                
                return [
                    'id' => (int) $item->id,
                    'pmid' =>  $item->pmid,
                    'mhid' => $item->mhid,
                    'doi' => $item->doi,
                    'authors'=>isset(json_decode($item->publicData, true)['authors'])? json_decode($item->publicData, true)['authors']: [],
                    'authors_verified'=> $author_verified
                ];
            })
            ->toArray();
       return response()->json(['status'=>true, 'articles'=>$articles]);
   }
    
    

    
    
    
    public function adminDashboard ()
    {
        try {
        // Total count of studies
        $total_studies = FinalArticle::count();


        // Modify years_graph to return an array
        $years_graph = FinalArticle::selectRaw('JSON_UNQUOTE(JSON_EXTRACT(publicData, "$.year.name")) as year, COUNT(*) as count')
            ->groupBy('year')
            ->orderBy('year', 'desc')
            ->get()
            ->map(function ($item) {
                return [
                    'year' => (int) $item->year,
                    'count' => (int) $item->count
                ];
            })
            ->toArray();
            
             $researchers = User::where('role', 'Researcher')->count();
             $users = User::where('role', 'User')->count();
             
             
             
             // Initialize study types
            $studyTypes = [];
            $studyTypes1 = StudyType::get();
            foreach ($studyTypes1 as $s) {
                $studyTypes[$s->name] = 0;
            }
    
            // Initialize species
            $species = [];
            $speics = Species::get();
            foreach ($speics as $s) {
                $species[$s->name] = 0;
            }
            
            $organs= [];
            $orga = Organs::get();
            foreach($orga as $o)
            {
                $organs[$o->name] = 0;
            }
            
            $rsTopics = [];
            $topics = ResearchTopics::get();
            foreach($topics as $t)
            {
                $rsTopics[$t->name] = 0;
            }
            
            
            // Loop through each article and count study types and species
            FinalArticle::each(function ($article) use (&$studyTypes, &$species, &$organs, &$rsTopics, &$methods) {
                
                // Count study types
              
                $studyTypeArray = json_decode($article->articleGeneralData, true)['studyType'] ?? [];
               
                if(count($studyTypeArray)>0)
                {
                //   dd($studyTypeArray,$studyTypes);
           
                    foreach ($studyTypeArray as $studyType) {
                        // dd($studyType);
                        if($studyType['name']!=="N/A")
                        {
                            // dd($studyType,$studyTypeArray,$studyTypes);
                            if (array_key_exists($studyType['name'], $studyTypes)) {
                            $studyTypes[$studyType['name']]++;
                            }
                        }
                        
                    }
                }
               
    
                // Count species
                $speciesArray = json_decode($article->articleGeneralData, true)['species'] ?? [];
                if(count($speciesArray)>0)
                {
                    foreach ($speciesArray as $specie) {
                        // dd($specie);
                        if (array_key_exists($specie['name'], $species)) {
                            $species[$specie['name']]++;
                        }
                    }
                }
                
                
                //Count Organs
                $organArray = json_decode($article->articleGeneralData, true)['organ'] ?? [];
                if(count($organArray)>0)
                {
                    foreach ($organArray as $og) {
                        if (array_key_exists($og['name'], $organs)) {
                            $organs[$og['name']]++;
                        }
                    }
                }
                
                //Count Research Topics
                $topicArray = json_decode($article->articleGeneralData, true)['researchtopic'] ?? [];
                if(count($topicArray)>0)
                {
                    foreach ($topicArray as $tp) {
                        if (array_key_exists($tp['name'], $rsTopics)) {
                            $rsTopics[$tp['name']]++;
                        }
                    }    
                }
                
                
                
               
            });
            
            
            foreach($studyTypes as $k => $count)
            {
                if($count == 0)
                {
                    unset($studyTypes[$k]);
                }
            }
            foreach($species as $k => $count)
            {
                if($count == 0)
                {
                    unset($species[$k]);
                }
            }
            foreach($organs as $k => $count)
            {
                if($count == 0)
                {
                    unset($organs[$k]);
                }
            }
            
            foreach($rsTopics as $k => $count)
            {
                if($count == 0)
                {
                    unset($rsTopics[$k]);
                }
            }
            
            
            $status = [
                'Verified'=>FinalArticle::where("status","Verified")->count(),
                'Unverified'=>FinalArticle::where("status","Unverified")->count(),
                'Draft'=>FinalArticle::where("status","Draft")->count(),
                "In_review"=>FinalArticle::where("status","In Review")->count()
            ];
        $data = [
            'total_studies' => $total_studies,
            'years_graph' => $years_graph,
            'total_researcher'=> $researchers,
            'user_count'=> $users,
            'study_type' => $studyTypes, // Add study type data
            'specie_count' => $species, // Add species count data
            'organs'=>$organs,
            'research_topics'=>$rsTopics,
            'status'=>$status
        ];

        // Return the response with status and data
        return response()->json([
            'status' => true,
            'message' => 'Data fetched successfully',
            'data' => $data
        ], 200); // 200 OK status
    } catch (\Exception $e) {
        // Handle errors and return a response with the error message
        return response()->json([
            'status' => false,
            'message' => 'An error occurred while fetching data: ' . $e->getMessage()
        ], 500); // 500 Internal Server Error status
    }
    }
    
    public function deleteArticle(Request $req, $id)
    {
        
        $article = FinalArticle::where('id', $id)->first();
        if($article)
        {
            $article->delete();
            return response()->json(['status'=>'Deleted','message'=>'Article Deleted'],200);
        }
        else
        {
             return response()->json(['status'=>'Not Found','message'=>'Article Not Found']);
        }
        // dd($article);
    }
    
    public function updateStatus(Request $req, $id)
    {
        if(!isset($req->status))
        {
            return response()->json(['message'=>'Status Not Found']);
        }
        $article = FinalArticle::where('id', $id)->first();
        if($article)
        {
            $article->status= $req->status;
            $article->save();
            return response()->json(['status'=>'Update','message'=>'Article Updated', 'article'=>$article],200);
        }
        else
        {
             return response()->json(['status'=>'Not Found','message'=>'Article Not Found']);
        }
    }
    
    public function userList()
    {
        $users = User::select('name', 'email', 'role','id','status')
    // ->where('role', '!=', 'Admin')
    ->get();
        return response()->json(['status'=>true, 'users'=>$users]);
    }
    
    public function userByID($user)
    {
        $user = User::select('name', 'email', 'role','id','status')
    ->where('id', $user)
    ->first();
        
        return response()->json(['status'=>true, 'user'=>$user]);
    }
    
    public function userAddUpdate(Request $req, $id = null)
    {
    // Determine if this is an update or a create operation
    $isUpdate = !is_null($id);

    if ($isUpdate) {
        // Update logic
        $validator = Validator::make($req->all(), [
            'name' => 'required',
            'role' => 'required',
            'status' => 'required',
            'email' => 'required|email',
        ]);

        if ($validator->fails()) {
        $errorMessages = implode(' ', $validator->errors()->all());
        return response()->json([
        'status' => 'error',
        'message' => $errorMessages, // Concatenated error messages
        ], 422);
        }
    
    
        
        // $checkEmail = User::where('id', '!=', $id)->where('email', $req->email)->first();
        // if ($checkEmail) {
        //     return response()->json(['status' => false, 'message' => 'A User with this email already exists'], 422);
        // }

        $user = User::find($id);
       // $user = User::where('id',$id)->first();
       // dd($user);
        if (!$user) {
            return response()->json(['status' => false, 'message' => 'User Not Found'], 404);
        }

        // Update user fields
        $user->name = $req->name ?? $user->name;
        $user->email = $req->email ?? $user->email;
        $user->status = $req->status ?? $user->status;
        $user->role = $req->role ?? $user->role;
        $user->save();

        return response()->json(['status' => true, 'message' => 'User updated successfully!', 'user' => $user]);
    } else {
       
        // Create logic
        $validator = Validator::make($req->all(), [
            'email' => 'required|email|unique:users,email',
            'password' => 'required',
            'name' => 'required',
            'role' => 'required',
            'status' => 'required',
        ]);
        
     
    
                if ($validator->fails()) {
                $errorMessages = implode(' ', $validator->errors()->all());
                return response()->json([
                'status' => 'error',
                'message' => $errorMessages, // Concatenated error messages
                ], 422);
                }
 
        $user = new User();
        $user->name = $req->name;
        $user->email = $req->email;
        $user->password = Hash::make($req->password);
        $user->role = $req->role;
        $user->status = $req->status;
        $user->save();

        return response()->json(['status' => true, 'message' => 'User added successfully!','user'=>$user]);
    }
}


 public function mhtoMhi()
    {
        $articles = FinalArticle::get();
        $newMhidArray = [];
        $articles = $articles->map(function($article){
            $idArray = str_split($article->mhid);
            
            for($i = 0; $i<count($idArray); $i++)
            {
                // dd($i);
                if($i==0)
                {
                    $newMhidArray[] = "MHI-";
                }
                
                $newMhidArray[] = $idArray[$i];
            }
            $newid = implode("",$newMhidArray);
            dd($newid);
            $article->mhid=$newid;
            $article->save();
         
        });
        return response()->json(['message'=>'Bar bar karay ga kia ? :D']);
    }
    public function authorsUpdate()
    {
        // $articles = FinalArticle::get();
        // $newMhidArray = [];
        // $articles = $articles->map(function($article){
        //   $decode = json_decode($article->publicData,true);
        //   $authors = [];
        //   if(isset($decode['authors']) && is_string($decode['authors']))
        //   {
        //       $oldauthors = explode(",", $decode['authors']);
        //       foreach($oldauthors as $au)
        //       {
        //           $authors[] = ['status'=>'Pending', 'name'=>$au];
        //       }
        //       $decode['authors'] = $authors;
        //       $article->publicData = json_encode($decode, true);
        //       $article->save();
        //   }
           
         
        // });
        return response()->json(['message'=>'Bar bar karay ga kia ? :D']);
    }
    
    public function fixArticle()
    {
        $articles = FinalArticle::get();
        $artArray = [];
        $articles = $articles->map(function($article){
          $decode = json_decode($article->publicData,true);
          if(isset($decode['pdf_url']))
          {
            //   dd($decode);
              if(!is_array($decode['pdf_url']))
              {
                  $artArray[] = $decode['pdf_url'];
                  $decode['pdf_url'] = $artArray;
                  $article->publicData = json_encode($decode, true);
                  $article->save();
                  $artArray = [];
              }
          }
          
         
        });
        
    }
    
    public function addRole(Request $req)
    {
        $role = new Roles();
        $role->name = $req->name;
        $role->save();
        return response()->json(['status'=>true, 'role'=>$role]);
    }
    
    public function getRoles()
    {
        $roles = Roles::get();
        return response()->json(['roles'=>$roles]);
    }
    
    public function viewRole(Roles $role)
    {
        return response()->json(['role'=>$role]);
    }
    
    public function editRole(Request $req, Roles $role)
    {
        $role->name = isset($req->name) ? $req->name : $role->name;
        $role->save();
        return response()->json(['status'=>true, 'message'=>'Role Updated', 'role'=>$role]);
    }
    
    public function deletetRole(Roles $role)
    {
        $role->delete();
        return response()->json(['message'=>'Deleted']);
    }
}
