<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PortalArticle extends Model
{
    protected $table= "p_article";
    use HasFactory;

     // Define the one-to-one relationship with System
    public function system()
    {
        return $this->hasOne(Systems::class, 'id', 'system'); // 'system' is the foreign key in p_article table
    }
    
    public function studies()
    {
        return $this->hasMany(PStudy::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    
    public function rstopics()
    {
        return $this->hasMany(PTopics::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    public function species()
    {
        return $this->hasMany(PSpecies::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    public function organs()
    {
        return $this->hasMany(POrgans::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    public function methods()
    {
        return $this->hasMany(PAdministrations::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    public function makers()
    {
        return $this->hasMany(PMakers::class, 'article_id', 'id'); // 'system' is the foreign key in p_article table
    }
    
}
