<?php 


namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    public function register(Request $req)
{
    $validator = Validator::make($req->all(), [
        'email' => 'required|email|unique:users,email', // Correct unique rule
        'password' => 'required',
        'name' => 'required',
        'role' => 'required' // Fixed typo: 'requried' to 'required'
    ]);

    if ($validator->fails()) {
        // Return validation errors in JSON format
        return response()->json([
            'status' => 'error',
            'errors' => $validator->errors(),
        ], 422); // 422 Unprocessable Entity
    }

    // Save the new user
    $user = new User();
    $user->name = $req->name;
    $user->email = $req->email;
    // Hash the password before saving it
    $user->password = Hash::make($req->password);
    $user->role = $req->role;

    if ($user->save()) {
        // Generate the token
        $token = $user->createToken('auth_token')->plainTextToken;

        // Return response
        return response()->json([
            'status' => 'Registered Successfully',
            'token' => $token,
            'user' => $user
        ], 200);
    }

    return response()->json([
        'status' => 'error',
        'message' => 'Registration failed'
    ], 500); // Handle case where saving user fails
}
    
    
    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
        'email' => 'required|email',
        'password' => 'required',
    ]);

    if ($validator->fails()) {
        // Return validation errors in JSON format
        return response()->json([
            'status' => 'error',
            'errors' => $validator->errors(),
        ], 422); // 422 Unprocessable Entity
    }
    

        // Attempt to find the user
        $user = User::where('email', $request->email)->first();

        // Verify password and generate token
        if ($user && Hash::check($request->password, $user->password)) {
            // Generate token
            $token = $user->createToken('auth_token')->plainTextToken;

            // Return the token
            return response()->json([
                'status' => 'success',
                'token' => $token,
                'user'=>$user
            ], 200);
        }

        // If authentication fails
        return response()->json([
            'status' => 'error',
            'message' => 'Invalid email or password',
        ], 401);
    }

    public function checkAuth(Request $request)
    {
    
        // Check if the Bearer token exists in the Authorization header
        $token = $request->bearerToken();

        if (!$token) {
            // No token found in the request
            return response()->json([
                'status' => 'error',
                'message' => 'Token not provided'
            ], 401);
        }

        // Fetch the user based on the token
        $user = $request->user();

        if ($user) {
            // If the user is successfully retrieved, return the user details
            return response()->json([
                'status' => 'success',
                'user' => $user,
                'role'=>$user->role
            ], 200);
        }

        // If the token is invalid or user is not authenticated
        return response()->json([
            'status' => 'error',
            'message' => 'Invalid token or user not authenticated'
        ], 401);
    }
}


?>