<?php

namespace App\Http\Controllers;
use App\Models\User;
use App\Models\Biomakers;
use App\Models\Species;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use App\Models\Articles;
use App\Models\StudyType;
use App\Models\ResearchTopics;
use App\Models\Organs;
use App\Models\Systems;
use App\Models\AdministrationMethods;
use App\Models\PAdministrations;
use App\Models\PMakers;
use App\Models\POrgans;
use App\Models\PSpecies;
use App\Models\PStudy;
use App\Models\PTopics;
use App\Models\Countries;
use App\Models\PortalArticle;
use App\Models\ArticleMoreDetails;
use App\Models\FinalArticle;
use App\Models\BioSub;
use App\Models\BioBridge;
use App\Models\BioCategories;
use CloudinaryLabs\CloudinaryLaravel\Facades\Cloudinary;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Http;

class ArticleController extends Controller
{
   public function getBotResponse(Request $req)
{
    if (!$req->has('url')) {
        return response()->json(['status' => false, 'message' => 'URL is missing']);
    }

    $apiUrl = "http://192.158.232.113/extract";
    $postData = json_encode(["url" => $req->url]);

    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, $apiUrl);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ["Content-Type: application/json"]);
    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false); // Disable SSL verification

    $response = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);

    if (curl_errno($ch)) {
        return response()->json(['status' => false, 'message' => 'cURL Error: ' . curl_error($ch)]);
    }

    curl_close($ch);
    $res= json_decode($response, true);
    return response()->json([
        'status' => ($httpCode === 200),
        'message'=>$res['message'],
        'data' => $res['data']
        
    ]);
}

public function pdfbot(Request $req)
{
    // Validate the request
    if (!$req->hasFile('file')) {
        return response()->json(['status' => false, 'message' => 'File is missing']);
    }

    $file = $req->file('file');

    if ($file->getClientOriginalExtension() !== 'pdf') {
        return response()->json(['status' => false, 'message' => 'Only PDF files are allowed']);
    }

    $apiUrl = "http://54.89.48.111:5000/upload";

    try {
        // Configure HTTP client with longer timeout and retry logic
        $response = Http::timeout(180) // 3 minutes timeout
            // ->retry(3, 5000) // Retry 3 times with 5 seconds between attempts
            ->withHeaders([
                'Accept' => 'application/json',
                'Connection' => 'keep-alive',
            ])
            ->attach(
                'file', 
                file_get_contents($file->getRealPath()), 
                $file->getClientOriginalName()
            )
            ->post($apiUrl);

        // Check for HTTP errors
        if ($response->failed()) {
            throw new \Exception("API Error: " . $response->body());
        }

        return response()->json([
            'status' => true,
            'message' => $response->json('message', 'File processed successfully'),
            'data' => $response->json('data')
        ]);

    } catch (\Illuminate\Http\Client\ConnectionException $e) {
        \Log::error("PDF Upload Connection Error: " . $e->getMessage());
        return response()->json([
            'status' => false,
            'message' => 'The PDF processing service is taking longer than expected. Please try again later.'
        ], 504); // Gateway Timeout
    } catch (\Exception $e) {
        \Log::error("PDF Upload Error: " . $e->getMessage());
        return response()->json([
            'status' => false,
            'message' => 'Failed to process PDF: ' . $e->getMessage()
        ], 500);
    }
}

// public function pdfbot(Request $req)
// {
//     if (!$req->hasFile('file')) {
//         return response()->json(['status' => false, 'message' => 'File is missing']);
//     }
    
//     $file = $req->file('file');
    
//     if ($file->getClientOriginalExtension() !== 'pdf') {
//         return response()->json(['status' => false, 'message' => 'Only PDF files are allowed']);
//     }
    
//     $apiUrl = "http://54.89.48.111:5000/upload";
    
//     try {
//         // Create a boundary for multipart form
//         $boundary = md5(time());
        
//         // Start building the multipart form data
//         $data = "--$boundary\r\n";
//         $data .= "Content-Disposition: form-data; name=\"file\"; filename=\"" . $file->getClientOriginalName() . "\"\r\n";
//         $data .= "Content-Type: application/pdf\r\n\r\n";
//         $data .= file_get_contents($file->getRealPath()) . "\r\n";
//         $data .= "--$boundary--\r\n";
        
//         // Context options
//         $options = [
//             'http' => [
//                 'method' => 'POST',
//                 'header' => "Content-Type: multipart/form-data; boundary=$boundary\r\n",
//                 'content' => $data,
//                 'timeout' => 60,
//             ],
//             'ssl' => [
//                 'verify_peer' => false,
//                 'verify_peer_name' => false,
//             ],
//         ];
        
//         $context = stream_context_create($options);
//         $response = file_get_contents($apiUrl, false, $context);
        
//         if ($response === false) {
//             throw new \Exception('Error communicating with server');
//         }
        
//         $res = json_decode($response, true);
        
//         return response()->json([
//             'status' => true,
//             'message' => $res['message'] ?? 'File processed',
//             'data' => $res['data'] ?? null
//         ]);
//     } catch (\Exception $e) {
//         \Log::error("PDF Bot Stream Error: " . $e->getMessage());
//         return response()->json([
//             'status' => false,
//             'message' => 'Error: ' . $e->getMessage()
//         ]);
//     }
// }


    public function getArticles()
    {
        // dd('yes');
        $article = Articles::get();
        return response()->json(['status'=>true, 'article'=>$article]);
    }
    
    public function keywordsArticles(Request $req)
    {
        $searchQuery = $req->keywords;

    // Query to find articles where title or abstract matches the search query
    $articles = Articles::query()
        ->where('title', 'like', '%' . $searchQuery . '%')
        ->orWhere('abstract', 'like', '%' . $searchQuery . '%')
        ->get();

    // Check if articles are found and return the response
    if ($articles->isNotEmpty()) {
        return response()->json([
            'status' => true,
            'articles' => $articles->toArray(),
        ]);
    } else {
        return response()->json(['status' => true, 'articles' => []]);
    }
    }
    
    
    public function filterByYear(Request $req)
    {
        $year = $req->year;
        // dd($year);
        $articles = Articles::where('year',$year)->get();
        if($articles)
        {
            
            return response()->json(
                ['status'=>true,
                'articles'=>$articles->toArray()
                ]);
        }
        else
        {
           return response()->json(['status'=>true,'articles'=>[]]); 
        }
    }
    
    public function filterArticles(Request $req)
    {
        // dd($req);
        $country = $req->country;
        $study_type = $req->study_type;
        $Species = $req->Species;
        $Disease = $req->Disease;
        $Organ = $req->Organ;
        $Systems = $req->Systems;
        
        $query = Articles::query();
        if(count($country)>0)
        {
            $query->whereIn('country',$country);
        }
        if(count($study_type)>0)
        {
            $query->whereIn('study_type',$study_type);
        }
        if(count($Species)>0)
        {
            $query->whereIn('species',$Species);
        }
        if(count($Disease)>0)
        {
            $query->whereIn('disease',$Disease);
        }
        if(count($Systems)>0)
        {
            $query->whereIn('system',$Systems);
        }
        if(count($Organ)>0)
        {
            $query->whereIn('organ',$Organ);
        }
        
        $articles = $query->get();
        if($articles)
        {
            
            return response()->json(
                ['status'=>true,
                'articles'=>$articles->toArray()
                ]);
        }
        else
        {
           return response()->json(['status'=>true,'articles'=>[]]); 
        }

        
    }


    public function getArticleById($id)
{
    // Fetch the primary article
    $article = FinalArticle::where('mhid',$id)->first();

    if (!$article) {
        return response()->json([
            'status' => false,
            'message' => 'Article not found',
        ], 404);
    }

    // Extract key fields from the primary article
    $articleGeneralData = json_decode($article->articleGeneralData ?? '{}', true);
    $researcherData = json_decode($article->researcherData ?? '{}', true);
    $publicData = json_decode($article->publicData ?? '{}', true);

    $researchTopics = $articleGeneralData['researchtopic'] ?? [];
    $species = $articleGeneralData['species'] ?? [];
    $methods = $researcherData['methods'] ?? [];
    $authors = $publicData['authors'] ?? [];

//   dd($researchTopics,$species,$methods);
    // Build the query for related articles
    $query = FinalArticle::query();

    // Match Research Topics
    if (!empty($researchTopics)) {
        $query->orWhere(function ($q) use ($researchTopics) {
            foreach ($researchTopics as $topic) {
                $q->orWhereRaw('JSON_CONTAINS(articleGeneralData, ?)', [json_encode($topic)]);
            }
        });
    }

    // Match Species
    if (!empty($species)) {
        $query->orWhere(function ($q) use ($species) {
            foreach ($species as $specie) {
                $q->orWhereRaw('JSON_CONTAINS(articleGeneralData, ?)', [json_encode($specie)]);
            }
        });
    }

    // Match Methods
    if (!empty($methods)) {
        $query->orWhere(function ($q) use ($methods) {
            foreach ($methods as $method) {
                $q->orWhereRaw('JSON_CONTAINS(researcherData, ?)', [json_encode($method)]);
            }
        });
    }


    $query->where('mhid', '!=', $id);

    // Order by publication date and limit to 3 related articles
    //$relatedArticles = FinalArticle::where('mhid', '!=' , $id)->orderBy('created_at', 'desc')->take(3)->get();
    $relatedArticles = $query->take(3)->get();
    
    if ($relatedArticles->isEmpty()) {
        $relatedArticles = FinalArticle::where('mhid', '!=' , $id)->orderBy('created_at', 'desc')->take(3)->get();
    }
    
    
    if($relatedArticles)
    // Decode JSON fields for related articles
    $decodedRelatedArticles = $relatedArticles->map(function ($article) {
        return [
            'id' => $article->id,
            'mhid' => $article->mhid,
            'doi' => $article->doi,
            'pmid' => $article->pmid,
            'status' => $article->status,
            'publicData' => json_decode($article->publicData, true),
            'articleGeneralData' => json_decode($article->articleGeneralData, true),
            'researcherData' => json_decode($article->researcherData, true),
            'biomaker' => json_decode($article->biomaker, true),
            'created_at' => $article->created_at,
            'updated_at' => $article->updated_at,
        ];
    });

    // Decode JSON fields for the primary article
    $article->publicData = isset($article->publicData) ? json_decode($article->publicData, true) : null;
    $article->articleGeneralData = isset($article->articleGeneralData) ? json_decode($article->articleGeneralData, true) : null;
    $article->researcherData = isset($article->researcherData) ? json_decode($article->researcherData, true) : null;
    $article->biomaker = isset($article->biomaker) ? json_decode($article->biomaker, true) : null;
    // Decode JSON fields properly
    $publicData =  $article->publicData;


    // Initialize author count array
    $authorCounts = [];

    // Fetch all articles to count author occurrences
    $allArticles = FinalArticle::select('publicData')->get();

    foreach ($allArticles as $singleArticle) {
        $singlePublicData = json_decode($singleArticle->publicData, true);
        if (!empty($singlePublicData['authors'])) {
            foreach ($singlePublicData['authors'] as $author) {
                $authorName = $author['name'] ?? null;
                if ($authorName) {
                    $authorCounts[$authorName] = ($authorCounts[$authorName] ?? 0) + 1;
                }
            }
        }
    }

    // Modify authors array safely
    if (!empty($publicData['authors'])) {
        foreach ($publicData['authors'] as $key => $author) {
            $authorName = $author['name'] ?? null;
            if ($authorName) {
                $publicData['authors'][$key]['article_count'] = $authorCounts[$authorName] ?? 0;
            }
        }
    }
    // dd($publicData);
$article->publicData = $publicData;
    // Return the response
    return response()->json([
        'status' => true,
        'article' => $article->toArray(),
        'related_article' => $decodedRelatedArticles,
    ]);
}

    
public function getArticleByMhid($id)
{
    // Retrieve the article by MHID
    $article = FinalArticle::where('mhid', $id)->first();

    if (!isset($article)) {
        return response()->json(['message' => 'Article not found'], 404);
    }

    // Decode JSON fields properly
    $publicData = isset($article->publicData) ? json_decode($article->publicData, true) : [];
    $articleGeneralData = isset($article->articleGeneralData) ? json_decode($article->articleGeneralData, true) : [];
    $researcherData = isset($article->researcherData) ? json_decode($article->researcherData, true) : [];
    $biomaker = isset($article->biomaker) ? json_decode($article->biomaker, true) : [];

    // Initialize author count array
    $authorCounts = [];

    // Fetch all articles to count author occurrences
    $allArticles = FinalArticle::select('publicData')->get();

    foreach ($allArticles as $singleArticle) {
        $singlePublicData = json_decode($singleArticle->publicData, true);
        if (!empty($singlePublicData['authors'])) {
            foreach ($singlePublicData['authors'] as $author) {
                $authorName = $author['name'] ?? null;
                if ($authorName) {
                    $authorCounts[$authorName] = ($authorCounts[$authorName] ?? 0) + 1;
                }
            }
        }
    }

    // Modify authors array safely
    if (!empty($publicData['authors'])) {
        foreach ($publicData['authors'] as $key => $author) {
            $authorName = $author['name'] ?? null;
            if ($authorName) {
                $publicData['authors'][$key]['article_count'] = $authorCounts[$authorName] ?? 0;
            }
        }
    }

    return response()->json([
        'status' => true,
        'article' => [
            'publicData' => $publicData,
            'articleGeneralData' => $articleGeneralData,
            'researcherData' => $researcherData,
            'biomaker' => $biomaker,
        ],
    ]);
}


    
    
    public function AddSpecie(Request $req)
    {
        $specie = new Species();
        $specie->name = $req->name;
        $specie->parent_id = $req->parent_id;
        $specie->save();
        
        return response()->json(['status'=>true,'specie'=>$specie, 'message'=>'Added Succesfully!'],200);
    }
    
    public function EditSpecie(Request $req,$spid)
    {
        $specie = Species::where('id',$spid)->first();
        if($specie)
        {
            $specie->name = isset($req->name) ? $req->name : $specie->name;
            $specie->parent_id = isset($req->parent_id) ? $req->parent_id: $specie->parent_id;
            $specie->save();
            return response()->json(['status'=>true,'specie'=>$specie,'message'=>'Updated Specie']);
        }
        
        return response()->json(['status'=>false,'message'=>'No Specie Found!']);
    }
    public function deleteSpecie(Request $req,$id)
    {
        $specie = Species::where('id',$id)->first();
        if($specie)
        {
            $specie->delete();
            return response()->json(['status'=>true,'specie'=>$specie,'message'=>'Deleted Specie']);
        }
        
        return response()->json(['status'=>false,'message'=>'No Specie Found!']);
    }
    
    
    public function ViewSpecie(Species $specie)
    {
        return response()->json(['status'=>true,'specie'=>$specie]);
    }
    
    public function allSpecies()
{
    // Get all species with their parent relationships loaded
    $species = Species::with('parent_id')->get();
    
    // Separate parents (species with no parent) and children
    $parents = $species->whereNull('parent_id');

    return response()->json([
        'status' => true,
        'species' => $species,
        'parents' => $parents->values() // Reset keys to ensure proper JSON array
    ]);
}
    
    
    
    public function updateMarkerFromFront(Request $req)
    {
        
       $biomarkers = Biomakers::where('name', $req->categoryName)->first();
       if(!$biomarkers)
       {
           return response()->json(['status'=>false,'message'=>'Not Found!']);
       }
       $makers = json_decode($biomarkers->makers);
       
       array_push($makers, $req->makers[0]);
       $biomarkers->makers  = json_encode($makers);
       $biomarkers->save();
       
       return response()->json(['status'=>true,'biomaker'=>$biomarkers,'message'=>'Added Succesfully!']);
    }
    
    public function getBiomakers()
    {
        $biomakers = Biomakers::get();
        $biomakers = $biomakers->toArray();
        foreach($biomakers as $key => $biomaker)
        {
            $biomakers[$key]['makers'] = json_decode($biomaker['makers']);
        }
        return response()->json(['status'=>true,'biomakers'=>$biomakers, 'message'=>'Fetched Succesfully!']);
    }
    
    public function editBioMaker(Request $req, $id)
    {
        // dd(json_encode($req->makers));
        $biomaker = Biomakers::where('id',$id)->first();
        // dd($biomaker);
        $biomaker->name = $req->categoryName;
        $biomaker->makers = json_encode($req->makers);
        $biomaker->save();
        
        return response()->json(['status'=>true,'biomaker'=>$biomaker, 'message'=>'Updated Succesfully!']);
    }
    
    
    public function addStudyType(Request $req)
    {
       $study_type = new StudyType();
       $study_type->name = $req->name;
       $study_type->save();
       
       return response()->json(['status'=>true,'study_type'=>$study_type,'message'=>'Added Succesfully!']);
    }
    
    public function editStudyType(Request $req, $id)
    {
        $study_type = StudyType::where('id',$id)->first();
        $study_type->name = $req->name;
        $study_type->save();
        return response()->json(['status'=>true,'study_type'=>$study_type, 'message'=>'Updated Succesfully!']);
        
    }
    
    public function deleteStudyType(Request $req, $id)
    {
        $study_type = StudyType::where('id',$id)->first();
        $study_type->delete();
        return response()->json(['status'=>true,'study_type'=>$study_type, 'message'=>'delete Succesfully!']);
        
    }
    public function getStudyType()
    {
        $study = StudyType::get();
        return response()->json(['status'=>true,'study_type'=>$study]);
    }
    public function addResearchTopic(Request $req)
    {
       $topic = new ResearchTopics();
       $topic->name = $req->name;
       $topic->save();
       
       return response()->json(['status'=>true,'research_topic'=>$topic,'message'=>'Added Succesfully!']);
    }
    public function editResearchTopic(Request $req, $id)
    {
        $topic = ResearchTopics::where('id',$id)->first();
        $topic->name = $req->name;
        $topic->save();
        return response()->json(['status'=>true,'research_topic'=>$topic, 'message'=>'Updated Succesfully!']);
        
    }
    public function deleteResearchTopic(Request $req, $id)
    {
        $topic = ResearchTopics::where('id',$id)->first();
        $topic->delete();
        return response()->json(['status'=>true,'research_topic'=>$topic, 'message'=>'delete Succesfully!']);
        
    }
    public function getResearchTopic()
    {
        $topic = ResearchTopics::get();
        return response()->json(['status'=>true,'research_topic'=>$topic]);
    }
    
    
    public function addOrgans(Request $req)
    {
       $organ = new Organs();
       $organ->name = $req->name;
       $organ->save();
       
       return response()->json(['status'=>true,'organs'=>$organ,'message'=>'Added Succesfully!']);
    }
    public function editOrgans(Request $req, $id)
    {
        $organ = Organs::where('id',$id)->first();
        $organ->name = $req->name;
        $organ->save();
        return response()->json(['status'=>true,'organs'=>$organ, 'message'=>'Updated Succesfully!']);
        
    }
    public function deleteOrgan(Request $req, $id)
    {
        $organ = Organs::where('id',$id)->first();
        $organ->delete();
        return response()->json(['status'=>true, 'organs'=>$organ, 'message'=>'Deleted Succesfully!']);
        
    }
    public function getOrgans()
    {
        $organ = Organs::get();
        return response()->json(['status'=>true,'organs'=>$organ]);
    }
    
    
    public function addSystem(Request $req)
    {
       $system = new Systems();
       $system->name = $req->name;
       $system->save();
       
       return response()->json(['status'=>true,'system'=>$system,'message'=>'Added Succesfully!']);
    }
    public function editSystem(Request $req, $id)
    {
        $system = Systems::where('id',$id)->first();
        $system->name = $req->name;
        $system->save();
        return response()->json(['status'=>true,'system'=>$system, 'message'=>'Updated Succesfully!']);
        
    }
    public function deletesystems(Request $req, $id)
    {
        $system = Systems::where('id',$id)->first();
        $system->delete();
        return response()->json(['status'=>true,'system'=>$system, 'message'=>'deleted Succesfully!']);
        
    }
    public function getSystems()
    {
        $system = Systems::get();
        return response()->json(['status'=>true,'system'=>$system]);
    }
    
    
    
    public function addMethods(Request $req)
    {
       $methods = new AdministrationMethods();
       $methods->name = $req->name;
       $methods->save();
       
       return response()->json(['status'=>true,'methods'=>$methods,'message'=>'Added Succesfully!']);
    }
    public function editMethods(Request $req, $id)
    {
        $methods = AdministrationMethods::where('id',$id)->first();
        $methods->name = $req->name;
        $methods->save();
        return response()->json(['status'=>true,'methods'=>$methods, 'message'=>'Updated Succesfully!']);
        
    }
    public function deleteMethods(Request $req, $id)
    {
        $methods = AdministrationMethods::where('id',$id)->first();
        $methods->delete();
        return response()->json(['status'=>true,'methods'=>$methods, 'message'=>'Deleted Succesfully!']);
        
    }
    public function getMethods()
    {
        $methods = AdministrationMethods::get();
        return response()->json(['status'=>true,'methods'=>$methods]);
    }
    
 public function newArticle(Request $req)
{
    $requestData = $req->json()->all();
    // dd($requestData['ConcentrationsQuestions']);

    // return response()->json(['status'=>true,'data'=>$requestData]);

    $article = new PortalArticle();
    $article->title = $requestData['title'] ?? null;
    $article->authors = $requestData['authors'] ?? null;
    $article->year = $requestData['year'] ?? null;
    $article->country = $requestData['country'] ?? null;
    $article->grantCountry = $requestData['grantCountry'] ?? null;
    $article->researchCountry = $requestData['researchCountry'] ?? null;
    $article->pmid = $requestData['pmid'] ?? null;
    $article->doi = $requestData['doi'] ?? null;
    $article->abstract = $requestData['abstract'] ?? null;
    $article->publisher = $requestData['publisher'] ?? null;
    $article->journal = $requestData['journal'] ?? null;
    $article->journalURL = $requestData['journalURL'] ?? null;
    $article->volume = $requestData['volume'] ?? null;
    $article->pages = $requestData['pages'] ?? null;
    $article->impactFactor = $requestData['impactFactor'] ?? null; 
    $article->HIndex = $requestData['HIndex'] ?? null;
    $article->sciMAGO = $requestData['sciMAGO'] ?? null;
    $article->outcome = $requestData['outcome'] ?? null;
    $article->HighlightArticle = isset($requestData['HighlightArticle']) && $requestData['HighlightArticle'] == "True" ? true : false;
    $article->descHighArt = $requestData['descHighArt'] ?? null;
    $article->rankThisArticle = $requestData['rankThisArticle'] ?? null;
    $article->HumanStudyType = $requestData['HumanStudyType'] ?? null;
    $article->Describestudytype = $requestData['Describestudytype'] ?? null;
    $article->ReviewStudyType = $requestData['ReviewStudyType'] ?? null;
    $article->CellCultureStudyType = $requestData['CellCultureStudyType'] ?? null;
    $article->diseaseModel = $requestData['diseaseModel'] ?? null;
    $article->ph = $requestData['ph'] ?? null;
    $article->isERW = isset($requestData['isERW']) && $requestData['isERW'] == "True" ? true : false;
    $article->drugComparison = isset($requestData['drugComparison']) && $requestData['drugComparison'] == "True" ? true : false;
    $article->comparisonDetail = $requestData['comparisonDetail'] ?? null;
    $article->pharmacokinetics = isset($requestData['pharmacokinetics']) && $requestData['pharmacokinetics'] == "True" ? true : false;
    $article->pharmacokineticsDescription = $requestData['pharmacokineticsDescription'] ?? null;
    $article->h2Duration = $requestData['h2Duration'] ?? null;
    $article->inhalationConcentration = $requestData['inhalationConcentration'] ?? null;
    $article->cellCultureConcentration = $requestData['cellCultureConcentration'] ?? null;
    $article->bothConcentration = $requestData['bothConcentration'] ?? null;
    $article->h2DoseBoth = $requestData['h2DoseBoth'] ?? null;
    $article->relativeDoseBoth = $requestData['relativeDoseBoth'] ?? null;
    $article->doseComparison = isset($requestData['doseComparison']) && $requestData['doseComparison'] == "True" ? true : false;
    $article->geneExpression = isset($requestData['geneExpression']) && $requestData['geneExpression'] == "True" ? true : false;
    
    // $article->descResearchTopic = $requestData['descResearchTopic'] ?? null;
    // $article->percentPurity = $requestData['percentPurity'] ?? null;
    // $article->FlowRateofHydrogen = $requestData['FlowRateofHydrogen'] ?? null;
    // $article->doseComparisonDesc = $requestData['doseComparisonDesc'] ?? null;
    // $article->geneExpressionDesc = $requestData['geneExpressionDesc'] ?? null;
    
    $article->status = "Draft";

    // Handling system if provided
    if (isset($requestData['system'])) {
        $system = Systems::where('name', $requestData['system'])->first();
        if ($system !== null) {
            $article->system = $system->id;
        }
    }

    if ($article->save()) {
        
        $moreDetails = new ArticleMoreDetails();
        $moreDetails->article_id = $article->id;
        $moreDetails->descResearchTopic = $requestData['descResearchTopic'] ?? null;
        $moreDetails->percentPurity = $requestData['percentPurity'] ?? null;
        $moreDetails->FlowRateofHydrogen = $requestData['FlowRateofHydrogen'] ?? null;
        $moreDetails->doseComparisonDesc = $requestData['doseComparisonDesc'] ?? null;
        $moreDetails->geneExpressionDesc = $requestData['geneExpressionDesc'] ?? null;
        $moreDetails->Video_WebpageLink = $requestData['Video_WebpageLink'] ?? null;
        $moreDetails->save();
        
        
        // Handling organs
        if (isset($requestData['organ']) && is_array($requestData['organ'])) {
            foreach ($requestData['organ'] as $v) {
                $organ = Organs::where('name', $v)->first();
                if ($organ !== null) {
                    $article_organ = new POrgans();
                    $article_organ->article_id = $article->id;
                    $article_organ->organ_id = $organ->id;
                    $article_organ->save();
                }
            }
        }

        // Handling studyType
        if (isset($requestData['studyType']) && is_array($requestData['studyType'])) {
            foreach ($requestData['studyType'] as $v) {
                $study = StudyType::where('name', $v)->first();
                if ($study !== null) {
                    $article_study = new PStudy();
                    $article_study->article_id = $article->id;
                    $article_study->study_type_id = $study->id;
                    $article_study->save();
                }
            }
        }

        // Handling researchtopic
        if (isset($requestData['researchtopic']) && is_array($requestData['researchtopic'])) {
            foreach ($requestData['researchtopic'] as $v) {
                $topics = ResearchTopics::where('name', $v)->first();
                if ($topics !== null) {
                    $article_topics = new PTopics();
                    $article_topics->article_id = $article->id;
                    $article_topics->rt_id = $topics->id;
                    $article_topics->save();
                }
            }
        }

        // Handling species
        if (isset($requestData['species']) && is_array($requestData['species'])) {
            foreach ($requestData['species'] as $v) {
                $sp = Species::where('name', $v)->first();
                if ($sp !== null) {
                    $article_species = new PSpecies();
                    $article_species->article_id = $article->id;
                    $article_species->specie_id = $sp->id;
                    $article_species->save();
                }
            }
        }

        // Handling methodOfAdmin
        if (isset($requestData['ConcentrationsQuestions']) && is_array($requestData['ConcentrationsQuestions'])) {
            foreach ($requestData['ConcentrationsQuestions'] as $v) {
                $ad = AdministrationMethods::where('name', $v['key'])->first();
                if ($ad !== null) {
                    $article_ad = new PAdministrations();
                    $article_ad->article_id = $article->id;
                    $article_ad->administration_id = $ad->id;
                    $article_ad->concentration = $v['answer'];
                    $article_ad->save();
                }
            }
        }

        // Handling biomakers
        if (isset($requestData['biomaker']) && is_array($requestData['biomaker'])) {
            foreach ($requestData['biomaker'] as $v) {
                $bio = Biomakers::where('name', $v['category'])->first();
                if ($bio !== null) {
                    $article_bio = new PMakers();
                    $article_bio->article_id = $article->id;
                    $article_bio->bio_id = $bio->id;
                    $article_bio->maker = $v['marker'] ?? null;
                    $article_bio->maker_2 = $v['Change'] ?? null;
                    $article_bio->maker_3 = $v['Protein'] ?? null;
                    $article_bio->save();
                }
            }
        }
    }

    return response()->json(['status' => true, 'data' => $article]);
}




public function upload(Request $request)
    {
        // dd(env('CLOUDINARY_URL'));
        // dd($request->file('file'));
        $request->validate([
            'file' => 'required|file|mimes:jpg,jpeg,png,gif,pdf'
        ]);

        // Upload file to Cloudinary
        $uploadedFileUrl = Cloudinary::upload($request->file('file')->getRealPath())->getSecurePath();

        return response()->json([
            'url' => $uploadedFileUrl
        ]);
    }

public function getPMID(Request $req, $pmid) {     
    // dd($pmid);
    $pmids = FinalArticle::where('pmid',$pmid)->first();
    $check = false;
    if($pmids)
    {
        $check=true;
    }
    // if($pmids)
    $article = $pmids ? ['id' => $pmids->id,
                'mhid' => $pmids->mhid,
                'doi' => $pmids->doi,
                'pmid' => $pmids->pmid,
                'status' => $pmids->status,
                'publicData' => json_decode($pmids->publicData, true),
                'articleGeneralData' => json_decode($pmids->articleGeneralData, true),
                'researcherData' => json_decode($pmids->researcherData, true),
                'biomaker' => json_decode($pmids->biomaker, true),
                'created_at' => $pmids->created_at,
                'updated_at' => $pmids->updated_at]:null;
    return response()->json(['status' => true, 'pmid' => $check,'article'=>$article]);      
    }
    
    
    
    public function fetchArticleDetails(Request $request)
    {
     
        $request->validate([
            'url' => 'required|url'
        ]);

        $url = $request->input('url');
        $client = new Client();

     
        $prompt = "Analyze the article at this URL: {$url}. Extract the following details: 
        - Title
        - Author names
        - DOI
        - Abstract text
        - PMID
        - Country of publication.
        If any details are missing, respond with 'N/A'.";

        try {
            //Chat GPT API
            $response = $client->post('https://api.openai.com/v1/chat/completions', [
                'headers' => [
                    'Authorization' => 'Bearer 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',
                    'Content-Type' => 'application/json',
                ],
                'json' => [
                    'model' => 'gpt-3.5-turbo', 
                   // 'model' => 'gpt-4o',
                    'messages' => [
                        [
                            'role' => 'user',
                            'content' => $prompt,
                        ],
                    ],
                    'max_tokens' => 1000,
                ],
            ]);

            $data = json_decode($response->getBody(), true);
            $result = $data['choices'][0]['message']['content']; //API Response Text

         
            $responseArray = $this->parseResponse($result);

     
            return response()->json(['result'=>$result,'array'=>$responseArray]);

        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Failed to fetch article details: ' . $e->getMessage()
            ], 500);
        }
    }

    private function parseResponse($responseText)
    {
        // Initialize the associative array with default values
        $details = [
            'title' => 'N/A',
            'authors' => 'N/A',
            'doi' => 'N/A',
            'abstract' => 'N/A',
            'pmid' => 'N/A',
            'country' => 'N/A'
        ];

        // Use regular expressions to extract each field from the response text
        if (preg_match('/Title:\s*(.*)/i', $responseText, $matches)) {
            $details['title'] = trim($matches[1]);
        }
        if (preg_match('/Author names?:\s*(.*)/i', $responseText, $matches)) {
            $details['authors'] = trim($matches[1]);
        }
        if (preg_match('/DOI:\s*(.*)/i', $responseText, $matches)) {
            $details['doi'] = trim($matches[1]);
        }
        if (preg_match('/Abstract text?:\s*(.*)/i', $responseText, $matches)) {
            $details['abstract'] = trim($matches[1]);
        }
        if (preg_match('/PMID:\s*(.*)/i', $responseText, $matches)) {
            $details['pmid'] = trim($matches[1]);
        }
        if (preg_match('/Country of publication:\s*(.*)/i', $responseText, $matches)) {
            $details['country'] = trim($matches[1]);
        }

        return $details;
    }
    
    
    
   public function HomePage(Request $req)
{
    try {
        // Total count of studies
        $total_studies = FinalArticle::count();

        // Count for Human Studies
        $human_study_count = FinalArticle::whereJsonContains('articleGeneralData->inVivo', 'Human Study')->count();

        // Count for Disease Models
        $disease_model_count = FinalArticle::whereNotNull('articleGeneralData->diseaseModel')
            ->where('articleGeneralData->diseaseModel', '!=', '')
            ->count();

        // Modify years_graph to return an array
        $years_graph = FinalArticle::selectRaw('JSON_UNQUOTE(JSON_EXTRACT(publicData, "$.year.name")) as year, COUNT(*) as count')
            ->groupBy('year')
            ->orderBy('year', 'desc')
            ->get()
            ->map(function ($item) {
                return [
                    'year' => (int) $item->year,
                    'count' => (int) $item->count
                ];
            })
            ->toArray();
            // dd($years_graph);
            

        // Initialize study types
        $studyTypes = [];
        $studyTypes1 = StudyType::get();
        foreach ($studyTypes1 as $s) {
            $studyTypes[$s->name] = 0;
        }

        // Initialize species
        $species = [];
        $speics = Species::get();
        foreach ($speics as $s) {
            $species[$s->name] = 0;
        }
        
        $organs= [];
        $orga = Organs::get();
        foreach($orga as $o)
        {
            $organs[$o->name] = 0;
        }
        
        $rsTopics = [];
        $topics = ResearchTopics::get();
        foreach($topics as $t)
        {
            $rsTopics[$t->name] = 0;
        }
        // Loop through each article and count study types and species
        FinalArticle::each(function ($article) use (&$studyTypes, &$species, &$organs, &$rsTopics) {
            // Count study types
            $studyTypeArray = json_decode($article->articleGeneralData, true)['studyType'] ?? [];
           
            // dd($studyTypeArray,json_decode($article->articleGeneralData, true));
            foreach ($studyTypeArray as $studyType) {
                
                if (array_key_exists($studyType['name'], $studyTypes)) {
                    $studyTypes[$studyType['name']]++;
                }
                // dd($studyTypeArray,$studyTypes);
            }

            // Count species
            $speciesArray = json_decode($article->articleGeneralData, true)['species'] ?? [];

            foreach ($speciesArray as $specie) {
                if (array_key_exists($specie['name'], $species)) {
                    $species[$specie['name']]++;
                }
            }
            
            
            //Count Organs
            $organArray = json_decode($article->articleGeneralData, true)['organ'] ?? [];
            foreach ($organArray as $og) {
                if (array_key_exists($og['name'], $organs)) {
                    $organs[$og['name']]++;
                }
            }
            // dd('yes');
            
            //Count Research Topics
            $topicArray = json_decode($article->articleGeneralData, true)['researchtopic'] ?? [];
            foreach ($topicArray as $tp) {
                if (array_key_exists($tp['name'], $rsTopics)) {
                    $rsTopics[$tp['name']]++;
                }
            }
        });
        // dd(array_key_exists('Rabbit', $species));
        foreach($studyTypes as $k => $count)
        {
            if($count == 0)
            {
                unset($studyTypes[$k]);
            }
        }
        foreach($species as $k => $count)
        {
            if($count == 0)
            {
                unset($species[$k]);
            }
        }
        $finalOrgan = [];
        foreach($organs as $k => $count)
        {
            if($count == 0)
            {
                unset($organs[$k]);
            }
            else
            {
                $finalOrgan[] = ['name'=>$k, 'count'=> $count];
            }
        }
        foreach($rsTopics as $k => $count)
        {
            if($count == 0)
            {
                unset($rsTopics[$k]);
            }
        }
        
        
        $latest_articles = FinalArticle::orderBy('id', 'DESC')->get()->take(10)->map(function ($item) {
                return [
                    'id' => (int) $item->id,
                    'pmid' =>  $item->pmid,
                    'mhid' => $item->mhid,
                    'publicData'=>json_decode($item->publicData, true)
                ];
            })
            ->toArray();;
        // dd($latest_articles);
        // Prepare the data array for response
        $data = [
            'total_studies' => $total_studies,
            'human_study_count' => $human_study_count,
            'disease_model_count' => $disease_model_count,
            'years_graph' => $years_graph,
            'study_type' => $studyTypes, // Add study type data
            'specie_count' => $species, // Add species count data
            'organs'=>$finalOrgan,
            'latest_articles'=>$latest_articles,
            'research_topics'=>$rsTopics,
        ];

        // Return the response with status and data
        return response()->json([
            'status' => true,
            'message' => 'Data fetched successfully',
            'data' => $data
        ], 200); // 200 OK status
    } catch (\Exception $e) {
        // Handle errors and return a response with the error message
        return response()->json([
            'status' => false,
            'message' => 'An error occurred while fetching data: ' . $e->getMessage()
        ], 500); // 500 Internal Server Error status
    }
}

public function getTitle(Request $req)
{
    // Ensure title input is provided
    $title = $req->input('title');
    
    if ($title) {
        // Query FinalArticle where the title in publicData matches the given title
        $articles = FinalArticle::whereRaw('JSON_UNQUOTE(JSON_EXTRACT(publicData, "$.title")) LIKE ?', ["%$title%"])
            ->get(['id', 'publicData','mhid']); // Only retrieve the id and publicData columns
        
        // Format the response to only return title and id
        $formattedArticles = $articles->map(function ($article) {
            $title = json_decode($article->publicData, true)['title'] ?? 'N/A'; // Extract title from publicData
            return [
                'title' => $title,
                'id' => $article->id,
                'mhid'=> $article->mhid
            ];
        });

        // Return formatted response
        if ($formattedArticles->isNotEmpty()) {
            return response()->json([
                'status' => true,
                'message' => 'Articles found',
                'data' => $formattedArticles
            ], 200); // 200 OK status
        } else {
            return response()->json([
                'status' => false,
                'message' => 'No articles found matching the title'
            ], 400); // 404 Not Found status
        }
    } else {
        return response()->json([
            'status' => false,
            'message' => 'Title parameter is required'
        ], 400); // 400 Bad Request status
    }
}


public function listArticles2(Request $req)
{
    $data = json_decode($req->getContent(), true);

    $perPage = $req->input('per_page', 10);
    $page = $req->input('page', 1);
    $searchTitle = $req->input('search_title', null);
    $HighlightArticle = $req->input('HighlightArticle', null);
    $title = $req->input('title',null);
    $year = $req->input('year', null);
    $status = $req->input('status',null);
    $request_type = $req->input('reqType',null);
    $admin_search = $req->input('admin_search', null);
    $filters = [
        'studyType' => $data['studyType'] ?? [],
        'country' => $data['country'] ?? [],
        'organ' => $data['organ'] ?? [],
        'species' => $data['species'] ?? [],
        'researchtopic' => $data['researchtopic'] ?? [],
        'system' => $data['system'] ?? [],
        'administration_methods' => $data['administration_methods'] ?? [],
        'grantCountry' => $data['grantCountry'] ?? [],
        'researchCountry' => $data['researchCountry'] ?? [],
        'outcomeType' => $data['outcomeType'] ?? [],
        'NonExperimentalSelect' => $data['NonExperimentalSelect'] ?? [],
        'inVivo' => $data['inVivo'] ?? [],
        'humanStudyType' => $data['humanStudyType'] ?? [],
        'clinicalTrialDesign' => $data['clinicalTrialDesign'] ?? [],
        'observationalStudy' => $data['observationalStudy'] ?? [],
        'marker' => $data['marker'] ?? [],
        'category' => $data['category'] ?? [],
        'authors' => $data['authors'] ?? []
    ];
    // dd($filters);
    try {
        $query = FinalArticle::query();
        
        if($year)
        {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.year.name')) = ?", [$year]);
        }
        if ($admin_search) {
            $query->where(function ($query) use ($admin_search) {
                $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $admin_search . '%'])
                    ->orWhereRaw("JSON_SEARCH(publicData, 'one', ?, NULL, '$.authors[*].name') IS NOT NULL", ['%' . $admin_search . '%'])
                    ->orWhere('pmid', '=', $admin_search);
            });
        }
        if ($searchTitle) {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $searchTitle . '%']);
        }
        if ($title) {
            // dd($title);
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $title . '%']);
        }
        if($status && $request_type == 'admin'){
            $query->where('status',$status);
        }
        // if($request_type == 'user' ||  $request_type==null){
        //     $query->where('status','Approved');
        // }
        if ($HighlightArticle) {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.HighlightArticle.name')) = ?", [$HighlightArticle]);
        }

        $filters = array_filter($filters, fn($value) => is_array($value) && count($value) > 0);
// dd($filters);
        \Log::info('Filtered (Non-Empty) Filters:', $filters);

        foreach ($filters as $field => $values) {
            if (!empty($values)) {
                $query->where(function ($query) use ($field, $values) {
                    foreach ($values as $value) {
                        $jsonValue = json_encode($value);
                        \Log::info("Filtering by {$field} with value:", [$jsonValue]);

                        if (in_array($field, ['country', 'grantCountry', 'researchCountry','authors'])) {
                            // dd($field,$jsonValue, $value );
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.{$field}[*].name')), 'one', ?) IS NOT NULL", [$value]);

                        } elseif ($field === 'species') {
                            // ✅ FIXED SPECIES FILTER
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.species[*].name')), 'one', ? ) IS NOT NULL", [$value]);

                        } elseif ($field === 'administration_methods') {
                            $speciesList = Species::pluck('name');
                            foreach ($speciesList as $species) {
                                $speciesPath = '$.speciesData."' . $species . '".methods';
                                $query->orWhereRaw("JSON_SEARCH(JSON_EXTRACT(researcherData, ?), 'one', ? ) IS NOT NULL", [$speciesPath, $value]);
                            }

                        } elseif (in_array($field, ['clinicalTrialDesign', 'observationalStudy', 'outcomeType'])) {
                            $query->orWhereRaw("JSON_SEARCH(JSON_EXTRACT(articleGeneralData, '$.{$field}[*]'), 'one', ?)", [$jsonValue]);

                        } elseif (in_array($field, ['studyType', 'NonExperimentalSelect', 'inVivo', 'researchtopic', 'system', 'organ'])) {
                            // dd($field);
                            if(($field!=="studyType") || ($field=="studyType" && in_array("in Vivo" , $values)))
                            {
                                $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.{$field}[*].name')), 'one', ? ) IS NOT NULL", [$value]);
                            }
                            if (($field=="studyType") && !in_array("in Vivo", $values))
                            {
                                if(in_array("Animal Study", $values))
                                {
                                     $query->orWhere(function($q) {
                $q->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Animal"])
                  ->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Animal Study"]);
            });
                                }
                                if(in_array("Human Study", $values))
                                {
                                    // Search inVivo array for "Human" or "Human Study"
            $query->orWhere(function($q) {
                $q->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Human"])
                  ->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Human Study"]);
            });
                                }
                            }

                        } elseif (in_array($field, ['marker', 'category'])) {
                            // dd($field,$jsonValue,$value);
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(biomaker, '$[*].{$field}')), 'one', ? ) IS NOT NULL", [$value]);

                        } elseif ($field === 'researchtopic') {
                            // ✅ FIXED QUERY FOR RESEARCHTOPIC (Removing Extra Quotes)
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.researchtopic[*].name')), 'one', ? ) IS NOT NULL", [$value]);

                        }else {
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.{$field}.name')), 'one', ? ) IS NOT NULL", [$jsonValue]);
                        }
                    }
                });
            }
        }

        // \Log::info($query->toSql());
        // \Log::info($query->getBindings());

        
        $keywords = [
        'hydrogen',
        'molecular hydrogen',
        'molecular hydrogen therapy',
        'dihydrogen',
        'dihydrogen therapy',
        'hydrogen gas',
        'H2 gas',
        'H2 inhalation',
        'hydrogen inhalation',
        'hydrogen therapy',
        'H2 therapy',
        'antioxidants',
        'pharmacokinetics',
        'inflammation',
        ];
        
        
        $genericKeywords = $req->input('genericKeywords', null);
        // dd($genericKeywords);
        // Apply generic keywords filter based on request
if ($genericKeywords !== null) {
    $filterByKeywords = $req->input('genericKeywords');
    
    $query->where(function($q) use ($keywords, $filterByKeywords) {
        foreach ($keywords as $keyword) {
            if ($filterByKeywords) {
                // Include articles that have any of the keywords
                $q->orWhere('publicData->title->name', 'LIKE', '%'.$keyword.'%')
                  ->orWhere('publicData->abstract->name', 'LIKE', '%'.$keyword.'%');
            } else {
                // Exclude articles that have any of the keywords
                $q->where(function($subQ) use ($keyword) {
                    $subQ->where('publicData->title->name', 'NOT LIKE', '%'.$keyword.'%')
                         ->where('publicData->abstract->name', 'NOT LIKE', '%'.$keyword.'%');
                });
            }
        }
    });
}
        
        
        
        $query->orderBy('id', 'DESC');
        $articles = $query->paginate($perPage, ['*'], 'page', $page);
        
        
        $keywordsLower = array_map('strtolower', $keywords);
        $decodedArticles = $articles->map(function ($article) use ($keywordsLower, $genericKeywords) {
            
            $publicData = json_decode($article->publicData, true);
     if($genericKeywords == null)
     {
            $title = strtolower($publicData['title']['name'] ?? '');
            $abstract = strtolower($publicData['abstract']['name'] ?? '');
            
            $hasKeyword = false;
            foreach ($keywordsLower as $keyword) {
                if (str_contains($title, $keyword) || str_contains($abstract, $keyword)) {
                    $hasKeyword = true;
                    break;
                }
            }
     }
    
            
            return [
                'id' => $article->id,
                'mhid' => $article->mhid,
                'doi' => $article->doi,
                'pmid' => $article->pmid,
                'status' => $article->status,
                'publicData' => json_decode($article->publicData, true),
                'articleGeneralData' => json_decode($article->articleGeneralData, true),
                'researcherData' => json_decode($article->researcherData, true),
                'biomaker' => json_decode($article->biomaker, true),
                'created_at' => $article->created_at,
                'updated_at' => $article->updated_at,
                'genericKeywords' => ($genericKeywords == null) ?  $hasKeyword : $genericKeywords,
            ];
        });

        return response()->json([
            'status' => true,
            'current_page' => $articles->currentPage(),
            'per_page' => $articles->perPage(),
            'total' => $articles->total(),
            'last_page' => $articles->lastPage(),
            'articles' => $decodedArticles,
        ], 200, [], JSON_PRETTY_PRINT);

    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'error' => $e->getMessage(),
            'complete_error'=>$e
        ], 500);
    }
}






public function listArticles(Request $req)
{
    $data = json_decode($req->getContent(), true);

    $perPage = $req->input('per_page', 10);
    $page = $req->input('page', 1);
    $searchTitle = $req->input('search_title', null);
    $HighlightArticle = $req->input('HighlightArticle', null);
    $title = $req->input('title',null);
    $year = $req->input('year', null);
    $status = $req->input('status',null);
    $request_type = $req->input('reqType',null);
    $admin_search = $req->input('admin_search', null);
    $filters = [
        'studyType' => $data['studyType'] ?? [],
        'country' => $data['country'] ?? [],
        'organ' => $data['organ'] ?? [],
        'species' => $data['species'] ?? [],
        'researchtopic' => $data['researchtopic'] ?? [],
        'system' => $data['system'] ?? [],
        'administration_methods' => $data['administration_methods'] ?? [],
        'grantCountry' => $data['grantCountry'] ?? [],
        'researchCountry' => $data['researchCountry'] ?? [],
        'outcomeType' => $data['outcomeType'] ?? [],
        'NonExperimentalSelect' => $data['NonExperimentalSelect'] ?? [],
        'inVivo' => $data['inVivo'] ?? [],
        'humanStudyType' => $data['humanStudyType'] ?? [],
        'clinicalTrialDesign' => $data['clinicalTrialDesign'] ?? [],
        'observationalStudy' => $data['observationalStudy'] ?? [],
        'marker' => $data['marker'] ?? [],
        'category' => $data['category'] ?? [],
        'authors'=>$data['authors']??[]
    ];

    try {
        $query = FinalArticle::query();
        
        if($year)
        {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.year.name')) = ?", [$year]);
        }
        if ($admin_search) {
            $query->where(function ($query) use ($admin_search) {
                $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $admin_search . '%'])
                    ->orWhereRaw("JSON_SEARCH(publicData, 'one', ?, NULL, '$.authors[*].name') IS NOT NULL", ['%' . $admin_search . '%'])
                    ->orWhere('pmid', '=', $admin_search);
            });
        }
        if ($searchTitle) {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $searchTitle . '%']);
        }
        if ($title) {
            // dd($title);
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.title.name')) LIKE ?", ['%' . $title . '%']);
        }
        if($status && $request_type == 'admin'){
            $query->where('status',$status);
        }
        // if($request_type == 'user' ||  $request_type==null){
        //     $query->where('status','Approved');
        // }
        if ($HighlightArticle) {
            $query->whereRaw("JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.HighlightArticle.name')) = ?", [$HighlightArticle]);
        }

        $filters = array_filter($filters, fn($value) => is_array($value) && count($value) > 0);
// dd($filters);
        \Log::info('Filtered (Non-Empty) Filters:', $filters);

        foreach ($filters as $field => $values) {
            if (!empty($values)) {
                $query->where(function ($query) use ($field, $values) {
                    foreach ($values as $value) {
                        $jsonValue = json_encode($value);
                        \Log::info("Filtering by {$field} with value:", [$jsonValue]);

                        if (in_array($field, ['country', 'grantCountry', 'researchCountry','authors'])) {
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(publicData, '$.{$field}[*].name')), 'one', ?) IS NOT NULL", [$value]);

                        } elseif ($field === 'species') {
                            // ✅ FIXED SPECIES FILTER
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.species[*].name')), 'one', ? ) IS NOT NULL", [$value]);

                        } elseif ($field === 'administration_methods') {
                            $speciesList = Species::pluck('name');
                            foreach ($speciesList as $species) {
                                $speciesPath = '$.speciesData."' . $species . '".methods';
                                $query->orWhereRaw("JSON_SEARCH(JSON_EXTRACT(researcherData, ?), 'one', ? ) IS NOT NULL", [$speciesPath, $value]);
                            }

                        } elseif (in_array($field, ['clinicalTrialDesign', 'observationalStudy', 'outcomeType'])) {
                            $query->orWhereRaw("JSON_SEARCH(JSON_EXTRACT(articleGeneralData, '$.{$field}[*]'), 'one', ?)", [$jsonValue]);

                        } elseif (in_array($field, ['studyType', 'NonExperimentalSelect', 'inVivo', 'researchtopic', 'system', 'organ'])) {
                            // dd($field);
                            if(($field!=="studyType") || ($field=="studyType" && in_array("in Vivo" , $values)))
                            {
                                $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.{$field}[*].name')), 'one', ? ) IS NOT NULL", [$value]);
                            }
                            if (($field=="studyType") && !in_array("in Vivo", $values))
                            {
                                if(in_array("Animal Study", $values))
                                {
                                    $query->orWhere(function($q) {
                                        $q->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Animal"])
                                        ->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Animal Study"]);
                                    });
                                }
                                if(in_array("Human Study", $values))
                                {
                                    // Search inVivo array for "Human" or "Human Study"
                                    $query->orWhere(function($q) {
                                        $q->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Human"])
                                          ->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.inVivo[*].name')), 'one', ?) IS NOT NULL", ["Human Study"]);
                                    });
                                }
                            }

                        } elseif (in_array($field, ['marker', 'category'])) {
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(biomaker, '$[*].{$field}')), 'one', ? ) IS NOT NULL", [$value]);

                        } elseif ($field === 'researchtopic') {
                            // ✅ FIXED QUERY FOR RESEARCHTOPIC (Removing Extra Quotes)
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.researchtopic[*].name')), 'one', ? ) IS NOT NULL", [$value]);

                        }else {
                            $query->orWhereRaw("JSON_SEARCH(JSON_UNQUOTE(JSON_EXTRACT(articleGeneralData, '$.{$field}.name')), 'one', ? ) IS NOT NULL", [$jsonValue]);
                        }
                    }
                });
            }
        }

        // \Log::info($query->toSql());
        // \Log::info($query->getBindings());

        
        $keywords = [
        'hydrogen',
        'molecular hydrogen',
        'molecular hydrogen therapy',
        'dihydrogen',
        'dihydrogen therapy',
        'hydrogen gas',
        'H2 gas',
        'H2 inhalation',
        'hydrogen inhalation',
        'hydrogen therapy',
        'H2 therapy',
        'antioxidants',
        'pharmacokinetics',
        'inflammation',
        ];
        
        
        $genericKeywords = $req->input('genericKeywords', null);
        // dd($genericKeywords);
        // Apply generic keywords filter based on request
if ($genericKeywords !== null) {
    $filterByKeywords = $req->input('genericKeywords');
    
    $query->where(function($q) use ($keywords, $filterByKeywords) {
        foreach ($keywords as $keyword) {
            if ($filterByKeywords) {
                // Include articles that have any of the keywords
                $q->orWhere('publicData->title->name', 'LIKE', '%'.$keyword.'%')
                  ->orWhere('publicData->abstract->name', 'LIKE', '%'.$keyword.'%');
            } else {
                // Exclude articles that have any of the keywords
                $q->where(function($subQ) use ($keyword) {
                    $subQ->where('publicData->title->name', 'NOT LIKE', '%'.$keyword.'%')
                         ->where('publicData->abstract->name', 'NOT LIKE', '%'.$keyword.'%');
                });
            }
        }
    });
}
        
        
        
        $query->orderBy('id', 'DESC');
        $articles = $query->paginate($perPage, ['*'], 'page', $page);
        
        
        $keywordsLower = array_map('strtolower', $keywords);
        $decodedArticles = $articles->map(function ($article) use ($keywordsLower, $genericKeywords) {
            
            $publicData = json_decode($article->publicData, true);
     if($genericKeywords == null)
     {
            $title = strtolower($publicData['title']['name'] ?? '');
            $abstract = strtolower($publicData['abstract']['name'] ?? '');
            
            $hasKeyword = false;
            foreach ($keywordsLower as $keyword) {
                if (str_contains($title, $keyword) || str_contains($abstract, $keyword)) {
                    $hasKeyword = true;
                    break;
                }
            }
     }
    
            
            return [
                'id' => $article->id,
                'mhid' => $article->mhid,
                'doi' => $article->doi,
                'pmid' => $article->pmid,
                'status' => $article->status,
                'publicData' => json_decode($article->publicData, true),
                'articleGeneralData' => json_decode($article->articleGeneralData, true),
                'researcherData' => json_decode($article->researcherData, true),
                'biomaker' => json_decode($article->biomaker, true),
                'created_at' => $article->created_at,
                'updated_at' => $article->updated_at,
                'genericKeywords' => ($genericKeywords == null) ?  $hasKeyword : $genericKeywords,
            ];
        });

        return response()->json([
            'status' => true,
            'current_page' => $articles->currentPage(),
            'per_page' => $articles->perPage(),
            'total' => $articles->total(),
            'last_page' => $articles->lastPage(),
            'articles' => $decodedArticles,
        ], 200, [], JSON_PRETTY_PRINT);

    } catch (\Exception $e) {
        return response()->json([
            'status' => false,
            'error' => $e->getMessage(),
            'complete_error'=>$e
        ], 500);
    }
}



public function getPArticles ()
{
    $articles = FinalArticle::orderBy('updated_at', 'desc')->get()->map(function ($article){
        return [
                'id' => $article->id,
                'mhid'=>$article->mhid,
                'doi' => $article->doi,
                'pmid' => $article->pmid,
                'status' => $article->status,
                'publicData' => json_decode($article->publicData, true),
                'articleGeneralData' => json_decode($article->articleGeneralData, true),
                'researcherData' => json_decode($article->researcherData, true),
                'biomaker' => json_decode($article->biomaker, true),
                'created_at' => $article->created_at,
                'updated_at' => $article->updated_at,
            ];
    });
    return response()->json(['status'=>true,'articles'=>$articles]);
}
public function getFilters(Request $req)
{
    $data['study_type']           = StudyType::orderBy('name')->get();
    $data['species']              = Species::where('parent_id',null)->orderBy('name')->get();
    $data['organs']               = Organs::orderBy('name')->get();
    $data['system']               = Systems::orderBy('name')->get();
    $data['research_topics']      = ResearchTopics::orderBy('name')->get();
    $data['administration_methods']= AdministrationMethods::orderBy('name')->get();
    $data['country']              = Countries::orderBy('name')->get();
    $data['grantCountry']         = Countries::orderBy('name')->get();
    $data['researchCountry']      = Countries::orderBy('name')->get();
    $data['marker']               = BioSub::where('status','Approved')
                                         ->orderBy('name')
                                         ->get();
    $data['category']             = BioCategories::orderBy('name')->get();

    return response()->json([
        'status' => true,
        'data'   => $data
    ]);
}


public function managedMakers(Request $req)
{
    // Fetch the BioSub models with related categories
    $subs = BioSub::with('categories')->where('status' , 'Approved')->get();
    // dd($subs);
    $cat = BioCategories::get();
// dd($subs);
    // Format the response to match the structure needed by the frontend
    $formattedData = $subs->map(function ($sub) {
        return [
            'sub_category_name' => $sub->name,  // Assuming `sub_category_name` is the field for the sub-category
            'categories' => $sub->categories->pluck('name')->toArray(),  // Assuming the `categories` have a `name` field
        ];
    });

    return response()->json(['status' => true, 'sub' => $formattedData,'category'=>$cat]);
}

public function RejectApproveMakers(Request $req)
{
    if(!isset($req->sub_id) or !isset($req->status))
    {
        return response()->json(['message'=>'ID or Status is missing']);
    }
    $sub = BioSub::where('id', $req->sub_id)->first();
    $sub->status = $req->status;
    $sub->save();
    
    return response()->json(['message'=>'Status Updated to '.$req->status , 'status'=>true]);
}

public function BioSubWithCatList()
{
    $subs = BioSub::with('categories')->orderBy('id', 'DESC')->get();
    return response()->json(['status' => true, 'sub' => $subs]);
}

public function addBioMarker(Request $req)
{
    // dd($req);
    
    $sub = new BioSub();
    $sub->name = $req->input('sub');
    $sub->status="Requested";
    $sub->save();
    
    foreach($req->input('categoryName') as $val )
    {
        $cat = BioCategories::where('name', $val)->first();
        $br = new BioBridge();
        $br->cat_id = $cat->id;
        $br->sub_id = $sub->id;
        $br->save();
    }
    
    return response(["status"=>true, "message"=>"Data Process to requested"]);
}

public function editBioMarker(Request $req, $id)
{
    
    $sub = BioSub::where('id',$id)->first();
    $sub->name = $req->sub;
    $sub->status = $req->status;
    $sub->save();
    
    $bridge = BioBridge::where('sub_id',$id)->delete();
    foreach($req->categoryName as $key => $val)
    {
        $cat = BioCategories::where('name',$val)->first();
        if($cat)
        {
            $br = new BioBridge();
            $br->cat_id = $cat->id;
            $br->sub_id = $sub->id;
            $br->save();
        }
    }
    
    $subs = BioSub::with('categories')->where('id', $sub->id)->first();
    return response()->json(['status'=>true, 'marker'=>$subs]);
}

public function viewMarker(Request $req, $id)
{
    $subs = BioSub::with('categories')->where('id', $id)->first();
    return response()->json(['status'=>true, 'marker'=>$subs]);
}
public function articleSubmit(Request $req)
{
    $msg = "Submited";
    
    if(isset($req->article_id))
    {
        $article = FinalArticle::where('id', intval($req->article_id))->first();
        $msg= "Updated";
    }
    else
    {
        $article = new FinalArticle();
         do {
            $uniqueNumber = str_pad(rand(0, 9999999), 7, '0', STR_PAD_LEFT); // Generate a 7-digit number
            $mhid = "MHID-" . $uniqueNumber;
        } while (FinalArticle::where('mhid', $mhid)->exists());

        $article->mhid = $mhid;
    }
    $article->doi = isset($req['publicData']['doi']['name'])? $req['publicData']['doi']['name']:null;
    $article->pmid = isset($req['publicData']['pmid']['name']) ? $req['publicData']['pmid']['name']: null;
    $article->publicData = isset($req->publicData) ? json_encode($req['publicData'],true) : null;
    $article->articleGeneralData =  isset($req->articleGeneralData) ? json_encode($req['articleGeneralData'],true): null;
    $article->researcherData = isset($req->researcherData) ?  json_encode($req['researcherData'],true) : null;
    $article->biomaker = isset($req->biomaker) ? json_encode($req['biomaker'],true):null;
    $article->status = isset($req->status)? $req->status: "Unverified";
    $article->save();
    
    return response()->json(["status"=>true, "article"=> $article,"message"=>"Article saved as ".$article->status]);
    
}
public function updateAllArticlesWithMhid()
{
    // Fetch all articles without an MHID
    $articles = FinalArticle::whereNull('mhid')->get();

    foreach ($articles as $article) {
        // Generate a unique MH ID
        do {
            $uniqueNumber = str_pad(rand(0, 9999999), 7, '0', STR_PAD_LEFT); // Generate a 7-digit number
            $mhid = "MH-" . $uniqueNumber;
        } while (FinalArticle::where('mhid', $mhid)->exists());

        // Assign the unique MHID to the article
        $article->mhid = $mhid;
        $article->save();
    }

    return response()->json(["status" => true, "message" => "All articles updated with unique MHID."]);
}
}
